/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.nms.v1_21_4;

import de.lars.inventoryframework.abstraction.SmithingTableInventory;
import de.lars.inventoryframework.adventuresupport.TextHolder;
import de.lars.inventoryframework.nms.v1_21_4.util.CustomInventoryUtil;
import de.lars.inventoryframework.nms.v1_21_4.util.TextHolderUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerSmithing;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmithingTableInventoryImpl
extends SmithingTableInventory {
    public SmithingTableInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    @NotNull
    public Inventory openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 4) {
            throw new IllegalArgumentException("The amount of items for a smithing table should be 4, but is '" + itemAmount + "'");
        }
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        CraftEventFactory.handleInventoryCloseEvent((EntityHuman)serverPlayer);
        serverPlayer.cd = serverPlayer.cc;
        IChatBaseComponent message = TextHolderUtil.toComponent(title);
        ContainerSmithingTableImpl containerSmithingTable = new ContainerSmithingTableImpl(serverPlayer, message);
        Inventory inventory = containerSmithingTable.getBukkitView().getTopInventory();
        inventory.setItem(0, items[0]);
        inventory.setItem(1, items[1]);
        inventory.setItem(2, items[2]);
        inventory.setItem(3, items[3]);
        int containerId = containerSmithingTable.getContainerId();
        serverPlayer.f.b((Packet)new PacketPlayOutOpenWindow(containerId, Containers.v, message));
        serverPlayer.cd = containerSmithingTable;
        serverPlayer.a((Container)containerSmithingTable);
        return inventory;
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items, @Nullable ItemStack cursor) {
        NonNullList<net.minecraft.world.item.ItemStack> nmsItems = CustomInventoryUtil.convertToNMSItems(items);
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        int state = serverPlayer.cd.k();
        net.minecraft.world.item.ItemStack nmsCursor = CraftItemStack.asNMSCopy((ItemStack)cursor);
        ServerPlayerConnection playerConnection = this.getPlayerConnection(serverPlayer);
        playerConnection.b((Packet)new PacketPlayOutWindowItems(containerId, state, nmsItems, nmsCursor));
    }

    @Override
    public void sendFirstItem(@NotNull Player player, @Nullable ItemStack item) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        int state = serverPlayer.cd.k();
        this.getPlayerConnection(serverPlayer).b((Packet)new PacketPlayOutSetSlot(containerId, state, 0, nmsItem));
    }

    @Override
    public void sendSecondItem(@NotNull Player player, @Nullable ItemStack item) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        int state = serverPlayer.cd.k();
        this.getPlayerConnection(serverPlayer).b((Packet)new PacketPlayOutSetSlot(containerId, state, 1, nmsItem));
    }

    @Override
    public void sendResultItem(@NotNull Player player, @Nullable ItemStack item) {
        this.sendResultItem(player, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public void clearResultItem(@NotNull Player player) {
        this.sendResultItem(player, net.minecraft.world.item.ItemStack.j);
    }

    @Override
    public void setCursor(@NotNull Player player, @NotNull ItemStack item) {
        this.setCursor(player, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int state = serverPlayer.cd.k();
        this.getPlayerConnection(serverPlayer).b((Packet)new PacketPlayOutSetSlot(-1, state, -1, net.minecraft.world.item.ItemStack.j));
    }

    @Deprecated
    private void setCursor(@NotNull Player player, @NotNull net.minecraft.world.item.ItemStack item) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int state = serverPlayer.cd.k();
        this.getPlayerConnection(serverPlayer).b((Packet)new PacketPlayOutSetSlot(-1, state, -1, item));
    }

    @Deprecated
    private void sendResultItem(@NotNull Player player, @NotNull net.minecraft.world.item.ItemStack item) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        int state = serverPlayer.cd.k();
        this.getPlayerConnection(serverPlayer).b((Packet)new PacketPlayOutSetSlot(containerId, state, 2, item));
    }

    @Deprecated
    @Contract(pure=true)
    private int getContainerId(@NotNull EntityHuman nmsPlayer) {
        return nmsPlayer.cd.l;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    private ServerPlayerConnection getPlayerConnection(@NotNull EntityPlayer serverPlayer) {
        return serverPlayer.f;
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private static class ContainerSmithingTableImpl
    extends ContainerSmithing {
        public ContainerSmithingTableImpl(@NotNull EntityPlayer serverPlayer, @NotNull IChatBaseComponent title) {
            super(serverPlayer.nextContainerCounter(), serverPlayer.gi(), ContainerAccess.a((World)serverPlayer.cU(), (BlockPosition)new BlockPosition(0, 0, 0)));
            this.setTitle(title);
            this.checkReachable = false;
            final Slot slotOne = (Slot)this.k.get(0);
            final Slot slotTwo = (Slot)this.k.get(1);
            final Slot slotThree = (Slot)this.k.get(2);
            final Slot slotFour = (Slot)this.k.get(3);
            this.k.set(0, (Object)new Slot(slotOne.c, slotOne.d, slotOne.e, slotOne.f){

                public boolean a(@NotNull net.minecraft.world.item.ItemStack stack) {
                    return true;
                }

                public boolean a(@NotNull EntityHuman playerEntity) {
                    return true;
                }

                public void a(@NotNull EntityHuman player, @NotNull net.minecraft.world.item.ItemStack stack) {
                    slotOne.a(player, stack);
                }
            });
            this.k.set(1, (Object)new Slot(slotTwo.c, slotTwo.d, slotTwo.e, slotTwo.f){

                public boolean a(@NotNull net.minecraft.world.item.ItemStack stack) {
                    return true;
                }

                public boolean a(@NotNull EntityHuman playerEntity) {
                    return true;
                }

                public void a(@NotNull EntityHuman player, @NotNull net.minecraft.world.item.ItemStack stack) {
                    slotTwo.a(player, stack);
                }
            });
            this.k.set(2, (Object)new Slot(slotThree.c, slotThree.d, slotThree.e, slotThree.f){

                public boolean a(@NotNull net.minecraft.world.item.ItemStack stack) {
                    return true;
                }

                public boolean a(@NotNull EntityHuman playerEntity) {
                    return true;
                }

                public void a(@NotNull EntityHuman player, @NotNull net.minecraft.world.item.ItemStack stack) {
                    slotThree.a(player, stack);
                }
            });
            this.k.set(3, (Object)new Slot(slotFour.c, slotFour.d, slotFour.e, slotFour.f){

                public boolean a(@NotNull net.minecraft.world.item.ItemStack stack) {
                    return true;
                }

                public boolean a(@NotNull EntityHuman playerEntity) {
                    return true;
                }

                public void a(@NotNull EntityHuman player, @NotNull net.minecraft.world.item.ItemStack stack) {
                    slotFour.a(player, stack);
                }
            });
        }

        @Contract(pure=true, value="_ -> true")
        public boolean b(@Nullable EntityHuman nmsPlayer) {
            return true;
        }

        public void a(IInventory container) {
        }

        public void a(EntityHuman nmsPlayer) {
        }

        public void l() {
        }

        protected void a(EntityHuman player, net.minecraft.world.item.ItemStack stack) {
        }

        protected boolean a(EntityHuman player, boolean present) {
            return true;
        }

        public int getContainerId() {
            return this.l;
        }
    }
}

