/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.pane.component;

import de.lars.inventoryframework.exception.XMLLoadException;
import de.lars.inventoryframework.gui.GuiItem;
import de.lars.inventoryframework.gui.InventoryComponent;
import de.lars.inventoryframework.gui.type.util.Gui;
import de.lars.inventoryframework.pane.PaginatedPane;
import de.lars.inventoryframework.pane.Pane;
import de.lars.inventoryframework.pane.util.Slot;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public class PagingButtons
extends Pane {
    @NotNull
    private final PaginatedPane pages;
    @NotNull
    private GuiItem backwardButton;
    @NotNull
    private GuiItem forwardButton;
    @NotNull
    private final Plugin plugin;

    public PagingButtons(@NotNull Slot slot, int length, @NotNull Pane.Priority priority, @NotNull PaginatedPane pages, @NotNull Plugin plugin) {
        super(slot, length, 1, priority);
        if (length < 2) {
            throw new IllegalArgumentException("Length of paging buttons must be at least 2");
        }
        this.pages = pages;
        this.plugin = plugin;
        this.backwardButton = new GuiItem(new ItemStack(Material.ARROW), plugin);
        this.forwardButton = new GuiItem(new ItemStack(Material.ARROW), plugin);
    }

    public PagingButtons(@NotNull Slot slot, int length, @NotNull Pane.Priority priority, @NotNull PaginatedPane pages) {
        this(slot, length, priority, pages, (Plugin)JavaPlugin.getProvidingPlugin(PagingButtons.class));
    }

    public PagingButtons(@NotNull Slot slot, int length, @NotNull PaginatedPane pages, @NotNull Plugin plugin) {
        this(slot, length, Pane.Priority.NORMAL, pages, plugin);
    }

    public PagingButtons(@NotNull Slot slot, int length, @NotNull PaginatedPane pages) {
        this(slot, length, Pane.Priority.NORMAL, pages);
    }

    public PagingButtons(int length, @NotNull Pane.Priority priority, @NotNull PaginatedPane pages, @NotNull Plugin plugin) {
        this(Slot.fromXY(0, 0), length, priority, pages, plugin);
    }

    public PagingButtons(int length, @NotNull Pane.Priority priority, @NotNull PaginatedPane pages) {
        this(Slot.fromXY(0, 0), length, priority, pages, (Plugin)JavaPlugin.getProvidingPlugin(PagingButtons.class));
    }

    public PagingButtons(int length, @NotNull PaginatedPane pages, @NotNull Plugin plugin) {
        this(Slot.fromXY(0, 0), length, Pane.Priority.NORMAL, pages, plugin);
    }

    public PagingButtons(int length, @NotNull PaginatedPane pages) {
        this(Slot.fromXY(0, 0), length, Pane.Priority.NORMAL, pages);
    }

    @Override
    public boolean click(@NotNull Gui gui, @NotNull InventoryComponent inventoryComponent, @NotNull InventoryClickEvent event, int slot, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int length = Math.min(this.length, maxLength);
        int height = Math.min(this.height, maxHeight);
        Slot paneSlot = this.getSlot();
        int xPosition = paneSlot.getX(maxLength);
        int yPosition = paneSlot.getY(maxLength);
        int totalLength = inventoryComponent.getLength();
        int adjustedSlot = slot - (xPosition + paneOffsetX) - totalLength * (yPosition + paneOffsetY);
        int x = adjustedSlot % totalLength;
        int y = adjustedSlot / totalLength;
        if (x < 0 || x >= length || y < 0 || y >= height) {
            return false;
        }
        this.callOnClick(event);
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null) {
            return false;
        }
        if (PagingButtons.matchesItem(this.backwardButton, itemStack)) {
            this.pages.setPage(this.pages.getPage() - 1);
            this.backwardButton.callAction(event);
            gui.update();
            return true;
        }
        if (PagingButtons.matchesItem(this.forwardButton, itemStack)) {
            this.pages.setPage(this.pages.getPage() + 1);
            this.forwardButton.callAction(event);
            gui.update();
            return true;
        }
        return false;
    }

    @Override
    public void display(@NotNull InventoryComponent inventoryComponent, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int length = Math.min(this.getLength(), maxLength);
        int x = this.slot.getX(length) + paneOffsetX;
        int y = this.slot.getY(length) + paneOffsetY;
        if (this.pages.getPage() > 0) {
            inventoryComponent.setItem(this.backwardButton, x, y);
        }
        if (this.pages.getPage() < this.pages.getPages() - 1) {
            inventoryComponent.setItem(this.forwardButton, x + length - 1, y);
        }
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public PagingButtons copy() {
        PagingButtons pagingButtons = new PagingButtons(this.getSlot(), this.getLength(), this.getPriority(), this.pages, this.plugin);
        pagingButtons.setVisible(this.isVisible());
        pagingButtons.onClick = this.onClick;
        pagingButtons.uuid = this.uuid;
        pagingButtons.backwardButton = this.backwardButton.copy();
        pagingButtons.forwardButton = this.forwardButton.copy();
        return pagingButtons;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Collection<GuiItem> getItems() {
        HashSet<GuiItem> items = new HashSet<GuiItem>();
        items.add(this.backwardButton);
        items.add(this.forwardButton);
        return Collections.unmodifiableCollection(items);
    }

    public void setBackwardButton(@NotNull GuiItem item) {
        this.backwardButton = item;
    }

    public void setForwardButton(@NotNull GuiItem item) {
        this.forwardButton = item;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Collection<Pane> getPanes() {
        return Collections.emptySet();
    }

    @Override
    public void clear() {
    }

    @NotNull
    @Contract(pure=true)
    public static PagingButtons load(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        int length;
        try {
            length = Integer.parseInt(element.getAttribute("length"));
        }
        catch (NumberFormatException exception) {
            throw new XMLLoadException(exception);
        }
        if (!element.hasAttribute("pages")) {
            throw new XMLLoadException("Paging buttons does not have pages attribute");
        }
        Element paginatedPaneElement = element.getOwnerDocument().getElementById(element.getAttribute("pages"));
        if (paginatedPaneElement == null) {
            throw new XMLLoadException("Paging buttons pages reference is invalid");
        }
        Object paginatedPane = paginatedPaneElement.getUserData("pane");
        if (!(paginatedPane instanceof PaginatedPane)) {
            throw new XMLLoadException("Retrieved data is not a paginated pane");
        }
        PagingButtons pagingButtons = new PagingButtons(length, (PaginatedPane)paginatedPane);
        Pane.load(pagingButtons, instance, element);
        return pagingButtons;
    }
}

