/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.util;

import de.lars.inventoryframework.exception.XMLLoadException;
import de.lars.inventoryframework.exception.XMLReflectionException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class XMLUtil {
    @Nullable
    @Contract(pure=true)
    public static <T extends Event> Consumer<T> loadOnEventAttribute(@NotNull Object instance, @NotNull Element element, @NotNull Class<T> eventType, @NotNull String name) {
        String attribute = element.getAttribute(name);
        for (Method method : instance.getClass().getMethods()) {
            boolean eventParameter;
            if (!method.getName().equals(attribute)) continue;
            int parameterCount = method.getParameterCount();
            if (parameterCount == 0) {
                eventParameter = false;
            } else {
                if (parameterCount != 1 || !eventType.isAssignableFrom(method.getParameterTypes()[0])) continue;
                eventParameter = true;
            }
            return event -> {
                try {
                    method.setAccessible(true);
                    if (eventParameter) {
                        method.invoke(instance, event);
                    } else {
                        method.invoke(instance, new Object[0]);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new XMLReflectionException(e);
                }
            };
        }
        return null;
    }

    public static void invokeMethod(@NotNull Object instance, @NotNull String methodName, @NotNull Object argument, @NotNull Class<?> parameter) {
        try {
            Method method = instance.getClass().getMethod(methodName, parameter);
            method.setAccessible(true);
            method.invoke(instance, argument);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            throw new XMLLoadException(exception);
        }
    }

    public static void loadFieldAttribute(@NotNull Object instance, @NotNull Element element, @Nullable Object value) {
        try {
            Field field = instance.getClass().getField(element.getAttribute("field"));
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new XMLLoadException(e);
        }
    }
}

