/*
 * Decompiled with CFR 0.152.
 */
package de.lars.inventoryframework.util.version;

import de.lars.inventoryframework.abstraction.AnvilInventory;
import de.lars.inventoryframework.abstraction.BeaconInventory;
import de.lars.inventoryframework.abstraction.CartographyTableInventory;
import de.lars.inventoryframework.abstraction.EnchantingTableInventory;
import de.lars.inventoryframework.abstraction.GrindstoneInventory;
import de.lars.inventoryframework.abstraction.MerchantInventory;
import de.lars.inventoryframework.abstraction.SmithingTableInventory;
import de.lars.inventoryframework.abstraction.StonecutterInventory;
import de.lars.inventoryframework.exception.UnsupportedVersionException;
import de.lars.inventoryframework.nms.v1_16_2_3.StonecutterInventoryImpl;
import de.lars.inventoryframework.nms.v1_16_4_5.AnvilInventoryImpl;
import de.lars.inventoryframework.nms.v1_18_0.MerchantInventoryImpl;
import de.lars.inventoryframework.nms.v1_19_1.CartographyTableInventoryImpl;
import de.lars.inventoryframework.nms.v1_19_2.GrindstoneInventoryImpl;
import de.lars.inventoryframework.nms.v1_19_4.LegacySmithingTableInventoryImpl;
import de.lars.inventoryframework.nms.v1_20_2.SmithingTableInventoryImpl;
import de.lars.inventoryframework.nms.v1_20_3.BeaconInventoryImpl;
import de.lars.inventoryframework.nms.v1_20_3.EnchantingTableInventoryImpl;
import de.lars.inventoryframework.util.version.Version;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumMap;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class VersionMatcher {
    private static final EnumMap<Version, Class<? extends AnvilInventory>> ANVIL_INVENTORIES = new EnumMap(Version.class);
    private static final EnumMap<Version, Class<? extends BeaconInventory>> BEACON_INVENTORIES;
    private static final EnumMap<Version, Class<? extends CartographyTableInventory>> CARTOGRAPHY_TABLE_INVENTORIES;
    private static final EnumMap<Version, Class<? extends EnchantingTableInventory>> ENCHANTING_TABLE_INVENTORIES;
    private static final EnumMap<Version, Class<? extends GrindstoneInventory>> GRINDSTONE_INVENTORIES;
    private static final EnumMap<Version, Class<? extends MerchantInventory>> MERCHANT_INVENTORIES;
    private static final EnumMap<Version, Class<? extends SmithingTableInventory>> SMITHING_TABLE_INVENTORIES;
    private static final EnumMap<Version, Class<? extends SmithingTableInventory>> LEGACY_SMITHING_TABLE_INVENTORIES;
    private static final EnumMap<Version, Class<? extends StonecutterInventory>> STONECUTTER_INVENTORIES;

    @NotNull
    @Contract(pure=true)
    public static AnvilInventory newAnvilInventory(@NotNull Version version, @NotNull InventoryHolder inventoryHolder) {
        try {
            return ANVIL_INVENTORIES.get((Object)version).getConstructor(InventoryHolder.class).newInstance(inventoryHolder);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static BeaconInventory newBeaconInventory(@NotNull Version version, @NotNull InventoryHolder inventoryHolder) {
        try {
            return BEACON_INVENTORIES.get((Object)version).getConstructor(InventoryHolder.class).newInstance(inventoryHolder);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static CartographyTableInventory newCartographyTableInventory(@NotNull Version version, @NotNull InventoryHolder inventoryHolder) {
        try {
            Class<? extends CartographyTableInventory> clazz = CARTOGRAPHY_TABLE_INVENTORIES.get((Object)version);
            return clazz.getConstructor(InventoryHolder.class).newInstance(inventoryHolder);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static EnchantingTableInventory newEnchantingTableInventory(@NotNull Version version, @NotNull InventoryHolder inventoryHolder) {
        try {
            Class<? extends EnchantingTableInventory> clazz = ENCHANTING_TABLE_INVENTORIES.get((Object)version);
            return clazz.getConstructor(InventoryHolder.class).newInstance(inventoryHolder);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static GrindstoneInventory newGrindstoneInventory(@NotNull Version version, @NotNull InventoryHolder inventoryHolder) {
        try {
            Class<? extends GrindstoneInventory> clazz = GRINDSTONE_INVENTORIES.get((Object)version);
            return clazz.getConstructor(InventoryHolder.class).newInstance(inventoryHolder);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static MerchantInventory newMerchantInventory(@NotNull Version version) {
        try {
            return MERCHANT_INVENTORIES.get((Object)version).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static SmithingTableInventory newModernSmithingTableInventory(@NotNull Version version, @NotNull InventoryHolder inventoryHolder) {
        if (!version.existsModernSmithingTable() && !version.existsLegacySmithingTable()) {
            throw new UnsupportedVersionException("Smithing tables didn't exist in version " + (Object)((Object)version));
        }
        if (!version.existsModernSmithingTable()) {
            throw new UnsupportedVersionException("Modern smithing tables didn't exist in version " + (Object)((Object)version));
        }
        try {
            Class<? extends SmithingTableInventory> clazz = SMITHING_TABLE_INVENTORIES.get((Object)version);
            return clazz.getConstructor(InventoryHolder.class).newInstance(inventoryHolder);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static SmithingTableInventory newSmithingTableInventory(@NotNull Version version, @NotNull InventoryHolder inventoryHolder) {
        if (!version.existsModernSmithingTable() && !version.existsLegacySmithingTable()) {
            throw new UnsupportedVersionException("Smithing tables didn't exist in version " + (Object)((Object)version));
        }
        if (!version.existsLegacySmithingTable()) {
            throw new UnsupportedVersionException("Legacy smithing tables don't exist in version " + (Object)((Object)version));
        }
        try {
            Class<? extends SmithingTableInventory> clazz = LEGACY_SMITHING_TABLE_INVENTORIES.get((Object)version);
            return clazz.getConstructor(InventoryHolder.class).newInstance(inventoryHolder);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static StonecutterInventory newStonecutterInventory(@NotNull Version version, @NotNull InventoryHolder inventoryHolder) {
        try {
            Class<? extends StonecutterInventory> clazz = STONECUTTER_INVENTORIES.get((Object)version);
            return clazz.getConstructor(InventoryHolder.class).newInstance(inventoryHolder);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    static {
        ANVIL_INVENTORIES.put(Version.V1_14, de.lars.inventoryframework.nms.v1_14.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_15, de.lars.inventoryframework.nms.v1_15.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_16_1, de.lars.inventoryframework.nms.v1_16_1.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_16_2_3, de.lars.inventoryframework.nms.v1_16_2_3.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_16_4_5, AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_17_0, de.lars.inventoryframework.nms.v1_17_0.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_17_1, de.lars.inventoryframework.nms.v1_17_1.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_18_0, de.lars.inventoryframework.nms.v1_18_0.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_18_1, de.lars.inventoryframework.nms.v1_18_1.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_18_2, de.lars.inventoryframework.nms.v1_18_2.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_19_0, de.lars.inventoryframework.nms.v1_19_0.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_19_1, de.lars.inventoryframework.nms.v1_19_1.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_19_2, de.lars.inventoryframework.nms.v1_19_2.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_19_3, de.lars.inventoryframework.nms.v1_19_3.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_19_4, de.lars.inventoryframework.nms.v1_19_4.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_20_0, de.lars.inventoryframework.nms.v1_20_0.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_20_1, de.lars.inventoryframework.nms.v1_20_1.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_20_2, de.lars.inventoryframework.nms.v1_20_2.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_20_3_4, de.lars.inventoryframework.nms.v1_20_3.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_20_5, de.lars.inventoryframework.nms.v1_20_5.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_20_6, de.lars.inventoryframework.nms.v1_20_6.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_21_0, de.lars.inventoryframework.nms.v1_21_0.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_21_1, de.lars.inventoryframework.nms.v1_21_1.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_21_2_3, de.lars.inventoryframework.nms.v1_21_2_3.AnvilInventoryImpl.class);
        ANVIL_INVENTORIES.put(Version.V1_21_4, de.lars.inventoryframework.nms.v1_21_4.AnvilInventoryImpl.class);
        BEACON_INVENTORIES = new EnumMap(Version.class);
        BEACON_INVENTORIES.put(Version.V1_14, de.lars.inventoryframework.nms.v1_14.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_15, de.lars.inventoryframework.nms.v1_15.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_16_1, de.lars.inventoryframework.nms.v1_16_1.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_16_2_3, de.lars.inventoryframework.nms.v1_16_2_3.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_16_4_5, de.lars.inventoryframework.nms.v1_16_4_5.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_17_0, de.lars.inventoryframework.nms.v1_17_0.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_17_1, de.lars.inventoryframework.nms.v1_17_1.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_18_0, de.lars.inventoryframework.nms.v1_18_0.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_18_1, de.lars.inventoryframework.nms.v1_18_1.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_18_2, de.lars.inventoryframework.nms.v1_18_2.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_19_0, de.lars.inventoryframework.nms.v1_19_0.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_19_1, de.lars.inventoryframework.nms.v1_19_1.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_19_2, de.lars.inventoryframework.nms.v1_19_2.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_19_3, de.lars.inventoryframework.nms.v1_19_3.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_19_4, de.lars.inventoryframework.nms.v1_19_4.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_20_0, de.lars.inventoryframework.nms.v1_20_0.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_20_1, de.lars.inventoryframework.nms.v1_20_1.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_20_2, de.lars.inventoryframework.nms.v1_20_2.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_20_3_4, BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_20_5, de.lars.inventoryframework.nms.v1_20_5.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_20_6, de.lars.inventoryframework.nms.v1_20_6.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_21_0, de.lars.inventoryframework.nms.v1_21_0.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_21_1, de.lars.inventoryframework.nms.v1_21_1.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_21_2_3, de.lars.inventoryframework.nms.v1_21_2_3.BeaconInventoryImpl.class);
        BEACON_INVENTORIES.put(Version.V1_21_4, de.lars.inventoryframework.nms.v1_21_4.BeaconInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES = new EnumMap(Version.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_14, de.lars.inventoryframework.nms.v1_14.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_15, de.lars.inventoryframework.nms.v1_15.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_16_1, de.lars.inventoryframework.nms.v1_16_1.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_16_2_3, de.lars.inventoryframework.nms.v1_16_2_3.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_16_4_5, de.lars.inventoryframework.nms.v1_16_4_5.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_17_0, de.lars.inventoryframework.nms.v1_17_0.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_17_1, de.lars.inventoryframework.nms.v1_17_1.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_18_0, de.lars.inventoryframework.nms.v1_18_0.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_18_1, de.lars.inventoryframework.nms.v1_18_1.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_18_2, de.lars.inventoryframework.nms.v1_18_2.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_19_0, de.lars.inventoryframework.nms.v1_19_0.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_19_1, CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_19_2, de.lars.inventoryframework.nms.v1_19_2.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_19_3, de.lars.inventoryframework.nms.v1_19_3.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_19_4, de.lars.inventoryframework.nms.v1_19_4.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_20_0, de.lars.inventoryframework.nms.v1_20_0.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_20_1, de.lars.inventoryframework.nms.v1_20_1.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_20_2, de.lars.inventoryframework.nms.v1_20_2.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_20_3_4, de.lars.inventoryframework.nms.v1_20_3.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_20_5, de.lars.inventoryframework.nms.v1_20_5.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_20_6, de.lars.inventoryframework.nms.v1_20_6.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_21_0, de.lars.inventoryframework.nms.v1_21_0.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_21_1, de.lars.inventoryframework.nms.v1_21_1.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_21_2_3, de.lars.inventoryframework.nms.v1_21_2_3.CartographyTableInventoryImpl.class);
        CARTOGRAPHY_TABLE_INVENTORIES.put(Version.V1_21_4, de.lars.inventoryframework.nms.v1_21_4.CartographyTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES = new EnumMap(Version.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_14, de.lars.inventoryframework.nms.v1_14.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_15, de.lars.inventoryframework.nms.v1_15.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_16_1, de.lars.inventoryframework.nms.v1_16_1.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_16_2_3, de.lars.inventoryframework.nms.v1_16_2_3.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_16_4_5, de.lars.inventoryframework.nms.v1_16_4_5.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_17_0, de.lars.inventoryframework.nms.v1_17_0.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_17_1, de.lars.inventoryframework.nms.v1_17_1.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_18_0, de.lars.inventoryframework.nms.v1_18_0.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_18_1, de.lars.inventoryframework.nms.v1_18_1.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_18_2, de.lars.inventoryframework.nms.v1_18_2.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_19_0, de.lars.inventoryframework.nms.v1_19_0.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_19_1, de.lars.inventoryframework.nms.v1_19_1.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_19_2, de.lars.inventoryframework.nms.v1_19_2.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_19_3, de.lars.inventoryframework.nms.v1_19_3.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_19_4, de.lars.inventoryframework.nms.v1_19_4.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_20_0, de.lars.inventoryframework.nms.v1_20_0.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_20_1, de.lars.inventoryframework.nms.v1_20_1.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_20_2, de.lars.inventoryframework.nms.v1_20_2.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_20_3_4, EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_20_5, de.lars.inventoryframework.nms.v1_20_5.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_20_6, de.lars.inventoryframework.nms.v1_20_6.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_21_0, de.lars.inventoryframework.nms.v1_21_0.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_21_1, de.lars.inventoryframework.nms.v1_21_1.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_21_2_3, de.lars.inventoryframework.nms.v1_21_2_3.EnchantingTableInventoryImpl.class);
        ENCHANTING_TABLE_INVENTORIES.put(Version.V1_21_4, de.lars.inventoryframework.nms.v1_21_4.EnchantingTableInventoryImpl.class);
        GRINDSTONE_INVENTORIES = new EnumMap(Version.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_14, de.lars.inventoryframework.nms.v1_14.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_15, de.lars.inventoryframework.nms.v1_15.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_16_1, de.lars.inventoryframework.nms.v1_16_1.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_16_2_3, de.lars.inventoryframework.nms.v1_16_2_3.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_16_4_5, de.lars.inventoryframework.nms.v1_16_4_5.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_17_0, de.lars.inventoryframework.nms.v1_17_0.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_17_1, de.lars.inventoryframework.nms.v1_17_1.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_18_0, de.lars.inventoryframework.nms.v1_18_0.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_18_1, de.lars.inventoryframework.nms.v1_18_1.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_18_2, de.lars.inventoryframework.nms.v1_18_2.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_19_0, de.lars.inventoryframework.nms.v1_19_0.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_19_1, de.lars.inventoryframework.nms.v1_19_1.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_19_2, GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_19_3, de.lars.inventoryframework.nms.v1_19_3.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_19_4, de.lars.inventoryframework.nms.v1_19_4.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_20_0, de.lars.inventoryframework.nms.v1_20_0.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_20_1, de.lars.inventoryframework.nms.v1_20_1.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_20_2, de.lars.inventoryframework.nms.v1_20_2.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_20_3_4, de.lars.inventoryframework.nms.v1_20_3.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_20_5, de.lars.inventoryframework.nms.v1_20_5.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_20_6, de.lars.inventoryframework.nms.v1_20_6.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_21_0, de.lars.inventoryframework.nms.v1_21_0.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_21_1, de.lars.inventoryframework.nms.v1_21_1.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_21_2_3, de.lars.inventoryframework.nms.v1_21_2_3.GrindstoneInventoryImpl.class);
        GRINDSTONE_INVENTORIES.put(Version.V1_21_4, de.lars.inventoryframework.nms.v1_21_4.GrindstoneInventoryImpl.class);
        MERCHANT_INVENTORIES = new EnumMap(Version.class);
        MERCHANT_INVENTORIES.put(Version.V1_14, de.lars.inventoryframework.nms.v1_14.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_15, de.lars.inventoryframework.nms.v1_15.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_16_1, de.lars.inventoryframework.nms.v1_16_1.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_16_2_3, de.lars.inventoryframework.nms.v1_16_2_3.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_16_4_5, de.lars.inventoryframework.nms.v1_16_4_5.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_17_0, de.lars.inventoryframework.nms.v1_17_0.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_17_1, de.lars.inventoryframework.nms.v1_17_1.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_18_0, MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_18_1, de.lars.inventoryframework.nms.v1_18_1.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_18_2, de.lars.inventoryframework.nms.v1_18_2.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_19_0, de.lars.inventoryframework.nms.v1_19_0.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_19_1, de.lars.inventoryframework.nms.v1_19_1.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_19_2, de.lars.inventoryframework.nms.v1_19_2.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_19_3, de.lars.inventoryframework.nms.v1_19_3.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_19_4, de.lars.inventoryframework.nms.v1_19_4.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_20_0, de.lars.inventoryframework.nms.v1_20_0.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_20_1, de.lars.inventoryframework.nms.v1_20_1.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_20_2, de.lars.inventoryframework.nms.v1_20_2.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_20_3_4, de.lars.inventoryframework.nms.v1_20_3.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_20_5, de.lars.inventoryframework.nms.v1_20_5.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_20_6, de.lars.inventoryframework.nms.v1_20_6.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_21_0, de.lars.inventoryframework.nms.v1_21_0.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_21_1, de.lars.inventoryframework.nms.v1_21_1.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_21_2_3, de.lars.inventoryframework.nms.v1_21_2_3.MerchantInventoryImpl.class);
        MERCHANT_INVENTORIES.put(Version.V1_21_4, de.lars.inventoryframework.nms.v1_21_4.MerchantInventoryImpl.class);
        SMITHING_TABLE_INVENTORIES = new EnumMap(Version.class);
        SMITHING_TABLE_INVENTORIES.put(Version.V1_19_4, de.lars.inventoryframework.nms.v1_19_4.SmithingTableInventoryImpl.class);
        SMITHING_TABLE_INVENTORIES.put(Version.V1_20_0, de.lars.inventoryframework.nms.v1_20_0.SmithingTableInventoryImpl.class);
        SMITHING_TABLE_INVENTORIES.put(Version.V1_20_1, de.lars.inventoryframework.nms.v1_20_1.SmithingTableInventoryImpl.class);
        SMITHING_TABLE_INVENTORIES.put(Version.V1_20_2, SmithingTableInventoryImpl.class);
        SMITHING_TABLE_INVENTORIES.put(Version.V1_20_3_4, de.lars.inventoryframework.nms.v1_20_3.SmithingTableInventoryImpl.class);
        SMITHING_TABLE_INVENTORIES.put(Version.V1_20_5, de.lars.inventoryframework.nms.v1_20_5.SmithingTableInventoryImpl.class);
        SMITHING_TABLE_INVENTORIES.put(Version.V1_20_6, de.lars.inventoryframework.nms.v1_20_6.SmithingTableInventoryImpl.class);
        SMITHING_TABLE_INVENTORIES.put(Version.V1_21_0, de.lars.inventoryframework.nms.v1_21_0.SmithingTableInventoryImpl.class);
        SMITHING_TABLE_INVENTORIES.put(Version.V1_21_1, de.lars.inventoryframework.nms.v1_21_1.SmithingTableInventoryImpl.class);
        SMITHING_TABLE_INVENTORIES.put(Version.V1_21_2_3, de.lars.inventoryframework.nms.v1_21_2_3.SmithingTableInventoryImpl.class);
        SMITHING_TABLE_INVENTORIES.put(Version.V1_21_4, de.lars.inventoryframework.nms.v1_21_4.SmithingTableInventoryImpl.class);
        LEGACY_SMITHING_TABLE_INVENTORIES = new EnumMap(Version.class);
        LEGACY_SMITHING_TABLE_INVENTORIES.put(Version.V1_16_1, de.lars.inventoryframework.nms.v1_16_1.SmithingTableInventoryImpl.class);
        LEGACY_SMITHING_TABLE_INVENTORIES.put(Version.V1_16_2_3, de.lars.inventoryframework.nms.v1_16_2_3.SmithingTableInventoryImpl.class);
        LEGACY_SMITHING_TABLE_INVENTORIES.put(Version.V1_16_4_5, de.lars.inventoryframework.nms.v1_16_4_5.SmithingTableInventoryImpl.class);
        LEGACY_SMITHING_TABLE_INVENTORIES.put(Version.V1_17_0, de.lars.inventoryframework.nms.v1_17_0.SmithingTableInventoryImpl.class);
        LEGACY_SMITHING_TABLE_INVENTORIES.put(Version.V1_17_1, de.lars.inventoryframework.nms.v1_17_1.SmithingTableInventoryImpl.class);
        LEGACY_SMITHING_TABLE_INVENTORIES.put(Version.V1_18_0, de.lars.inventoryframework.nms.v1_18_0.SmithingTableInventoryImpl.class);
        LEGACY_SMITHING_TABLE_INVENTORIES.put(Version.V1_18_1, de.lars.inventoryframework.nms.v1_18_1.SmithingTableInventoryImpl.class);
        LEGACY_SMITHING_TABLE_INVENTORIES.put(Version.V1_18_2, de.lars.inventoryframework.nms.v1_18_2.SmithingTableInventoryImpl.class);
        LEGACY_SMITHING_TABLE_INVENTORIES.put(Version.V1_19_0, de.lars.inventoryframework.nms.v1_19_0.SmithingTableInventoryImpl.class);
        LEGACY_SMITHING_TABLE_INVENTORIES.put(Version.V1_19_1, de.lars.inventoryframework.nms.v1_19_1.SmithingTableInventoryImpl.class);
        LEGACY_SMITHING_TABLE_INVENTORIES.put(Version.V1_19_2, de.lars.inventoryframework.nms.v1_19_2.SmithingTableInventoryImpl.class);
        LEGACY_SMITHING_TABLE_INVENTORIES.put(Version.V1_19_3, de.lars.inventoryframework.nms.v1_19_3.SmithingTableInventoryImpl.class);
        LEGACY_SMITHING_TABLE_INVENTORIES.put(Version.V1_19_4, LegacySmithingTableInventoryImpl.class);
        STONECUTTER_INVENTORIES = new EnumMap(Version.class);
        STONECUTTER_INVENTORIES.put(Version.V1_14, de.lars.inventoryframework.nms.v1_14.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_15, de.lars.inventoryframework.nms.v1_15.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_16_1, de.lars.inventoryframework.nms.v1_16_1.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_16_2_3, StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_16_4_5, de.lars.inventoryframework.nms.v1_16_4_5.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_17_0, de.lars.inventoryframework.nms.v1_17_0.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_17_1, de.lars.inventoryframework.nms.v1_17_1.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_18_0, de.lars.inventoryframework.nms.v1_18_0.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_18_1, de.lars.inventoryframework.nms.v1_18_1.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_18_2, de.lars.inventoryframework.nms.v1_18_2.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_19_0, de.lars.inventoryframework.nms.v1_19_0.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_19_1, de.lars.inventoryframework.nms.v1_19_1.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_19_2, de.lars.inventoryframework.nms.v1_19_2.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_19_3, de.lars.inventoryframework.nms.v1_19_3.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_19_4, de.lars.inventoryframework.nms.v1_19_4.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_20_0, de.lars.inventoryframework.nms.v1_20_0.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_20_1, de.lars.inventoryframework.nms.v1_20_1.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_20_2, de.lars.inventoryframework.nms.v1_20_2.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_20_3_4, de.lars.inventoryframework.nms.v1_20_3.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_20_5, de.lars.inventoryframework.nms.v1_20_5.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_20_6, de.lars.inventoryframework.nms.v1_20_6.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_21_0, de.lars.inventoryframework.nms.v1_21_0.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_21_1, de.lars.inventoryframework.nms.v1_21_1.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_21_2_3, de.lars.inventoryframework.nms.v1_21_2_3.StonecutterInventoryImpl.class);
        STONECUTTER_INVENTORIES.put(Version.V1_21_4, de.lars.inventoryframework.nms.v1_21_4.StonecutterInventoryImpl.class);
    }
}

